// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/public/common/background_sync.mojom
//

package org.chromium.mojom.content;

public final class SyncRegistration extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public long handleId;
    public int periodicity;
    public String tag;
    public long minPeriodMs;
    public int networkState;
    public int powerState;

    private SyncRegistration(int version) {
        super(STRUCT_SIZE, version);
        handleId = (long) -1L;
        periodicity = (int) BackgroundSyncPeriodicity.ONE_SHOT;
        tag = (String) "";
        minPeriodMs = (long) 0L;
        networkState = (int) BackgroundSyncNetworkState.ONLINE;
        powerState = (int) BackgroundSyncPowerState.AUTO;
    }

    public SyncRegistration() {
        this(0);
    }

    public static SyncRegistration deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static SyncRegistration decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        SyncRegistration result = new SyncRegistration(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.handleId = decoder0.readLong(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.periodicity = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.networkState = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.tag = decoder0.readString(24, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.minPeriodMs = decoder0.readLong(32);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.powerState = decoder0.readInt(40);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(handleId, 8);
        encoder0.encode(periodicity, 16);
        encoder0.encode(networkState, 20);
        encoder0.encode(tag, 24, false);
        encoder0.encode(minPeriodMs, 32);
        encoder0.encode(powerState, 40);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        SyncRegistration other = (SyncRegistration) object;
        if (this.handleId != other.handleId)
            return false;
        if (this.periodicity != other.periodicity)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.tag, other.tag))
            return false;
        if (this.minPeriodMs != other.minPeriodMs)
            return false;
        if (this.networkState != other.networkState)
            return false;
        if (this.powerState != other.powerState)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(handleId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(periodicity);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(tag);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(minPeriodMs);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(networkState);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(powerState);
        return result;
    }
}

